//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

`include "MCP2515_types.svh"
`include "can_msg_types.svh"

module  can_msg_to_tx_buf (
    input   can_msg_t       can_msg_in,
    output  can_tx_buf_t    tx_buf_out,
    output  logic           is_ext_data_frame
);

//-------------------------------------------------------------

// STD_ID[10] はデータとしては使用しない。
assign  {
    tx_buf_out.STD_ID, tx_buf_out.EXT_ID
} = {
    1'b0,
    can_msg_in.src_stn_id,
    can_msg_in.user,
    can_msg_in.msg_id,
    can_msg_in.dest_stn_id
};

assign  tx_buf_out.EXIDE     = 1'b1;
assign  tx_buf_out.RTR       = 1'b0;
assign  tx_buf_out.DLC       = can_msg_in.dlc;
assign  tx_buf_out.DATA_BYTE = can_msg_in.data;

assign  tx_buf_out.na0 = 1'b0;
assign  tx_buf_out.na1 = 1'b0;
assign  tx_buf_out.na2 = 1'b0;
assign  tx_buf_out.na3 = 2'b0;


assign  is_ext_data_frame = tx_buf_out.EXIDE & ~tx_buf_out.RTR;




endmodule

