//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  interval_timer #(
    parameter CNT_BIT_WIDTH = 0
) (
    input   wire   reset_n,
    input   wire   ck,
    input   wire   carry,
    input   wire   [CNT_BIT_WIDTH-1:0] interval,
    input   wire   en,
    output  logic  out
);

localparam  MSB  = CNT_BIT_WIDTH - 1;

//-----------------------------------------------------------
logic   [MSB:0] count;


//-----------------------------------------------------------

always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n )
        count <= 1'd0;
    else if ( ~en )
        count <= 1'd0;
    else if ( carry ) begin
        if (count < interval)
            count <= count + 1'd1;
        else
            count <= 1'd1;
    end
end


always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n )
        out <= 1'b0;
    else if (carry & (count == interval))
        out <= 1'b1;
    else
        out <= 1'b0;
end



endmodule


