//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  one_shot_trig #(
    parameter CNT_BIT_WIDTH = 0
) (
    input   wire   reset_n,
    input   wire   ck,
    input   wire   carry,
    input   wire   [CNT_BIT_WIDTH-1:0] delay,
    input   wire   en,
    output  logic  out
);

//-----------------------------------------------------------
logic   time_up;


on_timer #(
    .CNT_BIT_WIDTH   (CNT_BIT_WIDTH)
) 
delay_timer (
    .*,
    .delay  (delay),
    .in     (en),
    .out    (time_up)
);


rise_detector   time_up_detector (
    .* ,
   .in       (time_up),
   .out      (out)
);


endmodule

