//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  pulse_gen #(
    parameter CNT_BIT_WIDTH = 0
) (
    input   wire   reset_n,
    input   wire   ck,
    input   wire   carry,
    input   wire   [CNT_BIT_WIDTH-1:0] interval,
    input   wire   [CNT_BIT_WIDTH-1:0] pulse_width,
    input   wire   en,
    output  logic  out
);

//-----------------------------------------------------------
logic   set;
logic   rst;

//-----------------------------------------------------------

interval_timer #(
    .CNT_BIT_WIDTH   (CNT_BIT_WIDTH)
) 
pri_timer (
    .*,
    .interval   (interval),
    .en         (en),
    .out        (set)
);


on_timer #(
    .CNT_BIT_WIDTH   (CNT_BIT_WIDTH)
) 
pd_timer (
    .*,
    .delay  (pulse_width),
    .in     (out),
    .out    (rst)
);


sr_latch  sig_output (
    .*,
    .set    (set),
    .rst    (rst),
    .out    (out)
);



endmodule

