//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  shift_reg #(
    parameter   BYTE_LEN = 0,
    parameter   BIT_LEN = 0,
    parameter   LSB_FIRST_OUT = 0
) (
    reset_n, ck,
    data_load, data_in, data_out,
    shift_carry, shift_in, shift_out
);

`include "assert_param.svh"
initial begin
    `assert_param2(~((BYTE_LEN==0)&(BIT_LEN==0)), BYTE_LEN, BIT_LEN)
    `assert_param2(~((BYTE_LEN!=0)&(BIT_LEN!=0)), BYTE_LEN, BIT_LEN)
    `assert_param((LSB_FIRST_OUT==1)|(LSB_FIRST_OUT==0), LSB_FIRST_OUT)
end

// BYTE 指定、BIT 指定の両方に対応する。
localparam  BYTE_TYPE_MSB = BYTE_LEN*8 -1;
localparam  BIT_TYPE_MSB  = BIT_LEN    -1;
localparam  MSB = (BIT_LEN == 0) ? BYTE_TYPE_MSB : BIT_TYPE_MSB;


//------------------------------------------------------------
input   wire    reset_n;
input   wire    ck;

input   wire    data_load;
input   wire    [MSB:0] data_in;
output  wire    [MSB:0] data_out;
input   wire    shift_carry;
input   wire    shift_in;
output  wire    shift_out;


//------------------------------------------------------------
logic   [MSB:0] data;

generate
if (LSB_FIRST_OUT == 0) begin 
    //--- MSB first のデータを入力する場合 --------------
    always_ff @(posedge ck or negedge reset_n) begin
        if ( ~reset_n )
            data <= '0;
        else if ( data_load )
            data <= data_in;
        else if ( shift_carry )
            data <= {data[(MSB-1):0], shift_in};
    end

    assign  shift_out = data[MSB];
end
else begin
    //--- LSB first のデータを入力する場合 --------------
    always_ff @(posedge ck or negedge reset_n) begin
        if ( ~reset_n )
            data <= '0;
        else if ( data_load )
            data <= data_in;
        else if ( shift_carry )
            data <= {shift_in, data[MSB:1]};
    end

    assign  shift_out = data[0];
end
endgenerate


assign  data_out = data;


endmodule

