//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

//
//  下記の条件の場合処理すべき message と判定する。
//  (1) 受信した message が、extend id の data frame でかつ (1), (2) のいずれか
//      を満たす場合。　
//  (2) 宛先が all station 。　
//  (3) 宛先が 自 station id と一致。　
//
module  destination_filter (
    input   wire        reset_n,
    input   wire        ck,
    input   wire        [7:0] stn_id,
    rcv_data_if.in      rcv_data_in,
    can_msg_if.out      can_msg_out
);

`include "can_msg_types.svh"


typedef enum logic [1:0] {
    s_init,
    s_start_wait,
    s_message_check,
    s_trig_output
} state_t;


//-------------------------------------------------------------
state_t     curr_state, next_state;

logic       to_be_processed;
logic       trig;

can_msg_t   valid_can_msg;
can_msg_t   can_msg;
logic       is_ext_data_frame;


//-------------------------------------------------------------

rx_buf_to_can_msg  a_rx_buf_to_can_msg (
    .can_rx_buf_in      (rcv_data_in.rx_buf),
    .can_msg_out        (can_msg),
    .is_ext_data_frame  (is_ext_data_frame)
);



always_comb begin
    if ( is_ext_data_frame ) begin
        if (can_msg.dest_stn_id == 8'h00)
            to_be_processed = 1'b1; // 宛先が all station
        else if (can_msg.dest_stn_id == stn_id)
            to_be_processed = 1'b1; // 宛先が stn_id と一致。
        else
            to_be_processed = 1'b0;
    end
    else begin
        to_be_processed = 1'b0;
    end
end


assign  curr_state = next_state;

always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n ) begin
        trig <= 1'b0;
        next_state <= s_init;
    end
    else begin
        case ( curr_state )
            s_init: begin
                trig <= 1'b0;
                next_state <= s_start_wait;
            end

            s_start_wait: begin
                if ( rcv_data_in.trig )
                    next_state <= s_message_check;
            end

            s_message_check: begin
                if ( to_be_processed ) begin
                    next_state <= s_trig_output;
                end
                else begin
                    next_state <= s_init;
                end
            end

            s_trig_output: begin
                trig <= 1'b1;
                next_state <= s_init;
            end


            default: begin
                next_state <= s_init;
            end

        endcase
    end
end


always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n ) begin
        valid_can_msg <= '0;
    end
    else begin
        case ( curr_state )
            s_message_check: begin
                if ( to_be_processed ) begin
                    valid_can_msg <= can_msg;
                end
            end

            default: begin
                valid_can_msg <= valid_can_msg;
            end

        endcase
    end
end




assign  can_msg_out.msg  = valid_can_msg;
assign  can_msg_out.trig = trig;





endmodule

