//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  di_data_status_msg #(
    parameter   BYTE_LEN = 0
) (
    input   wire    reset_n,
    input   wire    ck,
    input   wire    trig,
    input   wire    [2:0] txbuf_busy,
    input   wire    [7:0] stn_id,
    input   wire    [BYTE_LEN*8-1:0] di_data,
    spi_cont_if.out cont_out
);

`include "assert_param.svh"
initial begin
    `assert_param((1<=BYTE_LEN)&(BYTE_LEN<=8), BYTE_LEN)
end

localparam  TXBUF_NUM = 0;

`include "can_msg_types.svh"
`include "can_msg.svh"


//-----------------------------------------------------------
can_msg_if      can_msg_bus();
can_msg_t       can_msg;




//-----------------------------------------------------------

assign  can_msg.src_stn_id  = stn_id;
assign  can_msg.user        = 4'b0;
assign  can_msg.msg_id      = MSG_DI_DATA;
assign  can_msg.dest_stn_id = 8'b0;
assign  can_msg.dlc         = BYTE_LEN[3:0];
assign  can_msg.data        = (64'b0 | di_data) << ((8-BYTE_LEN)*8); // MSB に詰める。


assign  can_msg_bus.msg  = can_msg;
assign  can_msg_bus.trig = trig;


msg_data_send #(
    .TXBUF_NUM  (TXBUF_NUM)
) 
di_data_sts_msg_send (
    .*,
    .txbuf_busy     (txbuf_busy),
    .done           (),
    .can_msg_in     (can_msg_bus),
    .cont_out       (cont_out)
);




endmodule


