//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  digital_output #(
    parameter SIG_BIT_WIDTH = 0
) (
    input   wire    reset_n,
    input   wire    ck,
    input   wire    set,
    input   wire    [SIG_BIT_WIDTH-1:0] data_in,
    output  logic   [SIG_BIT_WIDTH-1:0] data_out
);

//-----------------------------------------------------------

always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n )
        data_out <= '0;
    else begin
        if ( set )
            data_out <= data_in;
        else
            data_out <= data_out;
    end
end




endmodule

