//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  reset_gen #(
    parameter  RESET_COUNT = 10000
) (
    input   wire    ck,	
    output  logic   reset_n
);

`include "assert_param.svh"
initial begin
    `assert_param(RESET_COUNT > 0, RESET_COUNT)
end


localparam  MSB = $clog2(RESET_COUNT);

//-----------------------------------------------------------
logic   [MSB:0] count = '0; // initial value

//-----------------------------------------------------------

always @(posedge ck) begin
    if ( ~reset_n )
        count <= count + 1'd1;
    else
        count <= count;
end


always @(posedge ck) begin
    if (count < RESET_COUNT[MSB:0])
        reset_n <= 1'b0; 
    else
        reset_n <= 1'b1;
end



endmodule

