//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

`include "MCP2515_types.svh"
`include "can_msg_types.svh"

module  rx_buf_to_can_msg (
    input   can_rx_buf_t    can_rx_buf_in,
    output  can_msg_t       can_msg_out,
    output  logic           is_ext_data_frame
);

//-------------------------------------------------------------

// STD_ID[10] はデータとしては使用しない。
assign  {
    can_msg_out.src_stn_id,
    can_msg_out.user,
    can_msg_out.msg_id,
    can_msg_out.dest_stn_id
} = {
    can_rx_buf_in.STD_ID[9:0], can_rx_buf_in.EXT_ID
};

assign  can_msg_out.dlc  = can_rx_buf_in.DLC;
assign  can_msg_out.data = can_rx_buf_in.DATA_BYTE;


assign  is_ext_data_frame = (
    ~can_rx_buf_in.SRR & can_rx_buf_in.IDE & ~can_rx_buf_in.RTR
);




endmodule

