//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  spi_cont_combiner (
    spi_cont_if.in  port_1,
    spi_cont_if.in  port_2,
    spi_cont_if.in  port_3,
    spi_cont_if.in  port_4,
    spi_cont_if.in  port_5,

    spi_cont_comb_if.out    comb_out
);

//-------------------------------------------------------------

spi_cont_splitter  port_1_splitter (
    .cont_in    (port_1),
    .cont_mo    (comb_out.mo[1]),
    .cont_so    (comb_out.so[1])
);

spi_cont_splitter  port_2_splitter (
    .cont_in    (port_2),
    .cont_mo    (comb_out.mo[2]),
    .cont_so    (comb_out.so[2])
);

spi_cont_splitter  port_3_splitter (
    .cont_in    (port_3),
    .cont_mo    (comb_out.mo[3]),
    .cont_so    (comb_out.so[3])
);

spi_cont_splitter  port_4_splitter (
    .cont_in    (port_4),
    .cont_mo    (comb_out.mo[4]),
    .cont_so    (comb_out.so[4])
);

spi_cont_splitter  port_5_splitter (
    .cont_in    (port_5),
    .cont_mo    (comb_out.mo[5]),
    .cont_so    (comb_out.so[5])
);






endmodule


