//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------

//---------------------------------------------------
// MCP2515 SPI instruction set
localparam  CMD_RESET       = 8'b1100_0000;
localparam  CMD_READ        = 8'b0000_0011;
localparam  CMD_READ_RX_BUF = 8'b1001_0000; // 1001_0nm0
localparam  CMD_WRITE       = 8'b0000_0010;
localparam  CMD_LOAD_TX_BUF = 8'b0100_0000; // 0100_0abc
localparam  CMD_REQ_TO_SEND = 8'b1000_0000; // 1000_0[~2][~1][~0] : TXBn
localparam  CMD_READ_STATUS = 8'b1010_0000;
localparam  CMD_RX_STATUS   = 8'b1011_0000;
localparam  CMD_BIT_MODIFY  = 8'b0000_0101;

localparam  CMD_READ_RX_BUF_AT_RXB0_SIDH = 8'b0000_0000;
localparam  CMD_READ_RX_BUF_AT_RXB1_SIDH = 8'b0000_0100;

localparam  CMD_LOAD_TX_BUF_AT_TXB0_SIDH = 8'b0100_0000;
localparam  CMD_LOAD_TX_BUF_AT_TXB1_SIDH = 8'b0100_0010;
localparam  CMD_LOAD_TX_BUF_AT_TXB2_SIDH = 8'b0100_0100;

localparam  CMD_REQ_TO_SEND_TXB0 = 8'b1000_0001; // 1000_0[~2][~1][~0] : TXBn
localparam  CMD_REQ_TO_SEND_TXB1 = 8'b1000_0010; // 1000_0[~2][~1][~0] : TXBn
localparam  CMD_REQ_TO_SEND_TXB2 = 8'b1000_0100; // 1000_0[~2][~1][~0] : TXBn

//---------------------------------------------------
// READ STATUS 命令で取得するデータのビット位置
localparam  STATUS_CANINTF_TX2IF   = 8'b1000_0000;
localparam  STATUS_TXB2CNTRL_TXREQ = 8'b0100_0000;
localparam  STATUS_CANINTF_TX1IF   = 8'b0010_0000;
localparam  STATUS_TXB1CNTRL_TXREQ = 8'b0001_0000;
localparam  STATUS_CANINTF_TX0IF   = 8'b0000_1000;
localparam  STATUS_TXB0CNTRL_TXREQ = 8'b0000_0100;
localparam  STATUS_CANINTF_RX1IF   = 8'b0000_0010;
localparam  STATUS_CANINTF_RX0IF   = 8'b0000_0001;

localparam  MASK_STATUS_TX012IF =
(
    STATUS_CANINTF_TX2IF |
    STATUS_CANINTF_TX1IF |
    STATUS_CANINTF_TX0IF
);


//---------------------------------------------------
// Register Address
localparam  ADRS_CANCTRL  = 8'h0f;

localparam  ADRS_CNF3     = 8'h28;
localparam  ADRS_CNF2     = 8'h29;
localparam  ADRS_CNF1     = 8'h2a;
localparam  ADRS_CANINTE  = 8'h2b;
localparam  ADRS_CANINTF  = 8'h2c;

localparam  ADRS_RXF0SIDH = 8'h00;
localparam  ADRS_RXF1SIDH = 8'h04;
localparam  ADRS_RXF2SIDH = 8'h08;
localparam  ADRS_RXF3SIDH = 8'h10;
localparam  ADRS_RXF4SIDH = 8'h14;
localparam  ADRS_RXF5SIDH = 8'h18;

localparam  ADRS_RXM0SIDH = 8'h20;
localparam  ADRS_RXM1SIDH = 8'h24;

localparam  ADRS_RXB0CTRL = 8'h60;
localparam  ADRS_RXB1CTRL = 8'h70;


//---------------------------------------------------
// CAN control register 
localparam  REQOP_NORMAL      = 3'b000;
localparam  REQOP_SLEEP       = 3'b001;
localparam  REQOP_LOOPBACK    = 3'b010;
localparam  REQOP_LISTEN_ONLY = 3'b011;
localparam  REQOP_CONFIG      = 3'b100;

localparam  MASK_CAN_CTRL_REQOP = 8'b1110_0000;


//---------------------------------------------------
// CAN interrupt enable
localparam  CANINTE_MERRE   = 8'b1000_0000;
localparam  CANINTE_WAKIE   = 8'b0100_0000;
localparam  CANINTE_ERRIE   = 8'b0010_0000;
localparam  CANINTE_TX2IE   = 8'b0001_0000;
localparam  CANINTE_TX1IE   = 8'b0000_1000;
localparam  CANINTE_TX0IE   = 8'b0000_0100;
localparam  CANINTE_RX1IE   = 8'b0000_0010;
localparam  CANINTE_RX0IE   = 8'b0000_0001;


//---------------------------------------------------
// CAN interrupt flag
localparam  CANINTF_MERRF   = 8'b1000_0000;
localparam  CANINTF_WAKIF   = 8'b0100_0000;
localparam  CANINTF_ERRIF   = 8'b0010_0000;
localparam  CANINTF_TX2IF   = 8'b0001_0000;
localparam  CANINTF_TX1IF   = 8'b0000_1000;
localparam  CANINTF_TX0IF   = 8'b0000_0100;
localparam  CANINTF_RX1IF   = 8'b0000_0010;
localparam  CANINTF_RX0IF   = 8'b0000_0001;



