//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------


//---------------------------------------------------
// CAN control register 
typedef struct packed {
    logic   [2:0] REQOP;
    logic   ABAT;
    logic   OSM;
    logic   CLKEN;
    logic   [1:0] CLKPRE;
} CANCTRL_t;


//---------------------------------------------------
// CAN interrupt enable
typedef struct packed {
    logic   MERRE;
    logic   WAKIE;
    logic   ERRIE;
    logic   TX2IE;
    logic   TX1IE;
    logic   TX0IE;
    logic   RX1IE;
    logic   RX0IE;
} CANINTE_t;


//---------------------------------------------------
// CAN interrupt flag
typedef struct packed {
    logic   MERRF;
    logic   WAKIF;
    logic   ERRIF;
    logic   TX2IF;
    logic   TX1IF;
    logic   TX0IF;
    logic   RX1IF;
    logic   RX0IF;
} CANINTF_t;


//---------------------------------------------------
// Configuration register 1
typedef struct packed {
    logic   [1:0] SJW;
    logic   [5:0] BRP;
} CNF1_t;

//---------------------------------------------------
// Configuration register 2
typedef struct packed {
    logic   BTLMODE;
    logic   SAM;
    logic   [2:0] PHSEG1;
    logic   [2:0] PRSEG;
} CNF2_t;

//---------------------------------------------------
// Configuration register 3
typedef struct packed {
    logic   SOF;
    logic   WAKFIL;
    logic   [2:0] na;
    logic   [2:0] PHSEG2;
} CNF3_t;


//---------------------------------------------------
// Transmit buffer control register
typedef struct packed {
    logic   na1;
    logic   ABTF;
    logic   MLOA;
    logic   TXERR;
    logic   TXREQ;
    logic   na2;
    logic   [1:0] TXP;
} TXBnCTRL_t;


//---------------------------------------------------
// Receive buffer 0 control register
typedef struct packed {
    logic   na1;
    logic   [1:0] RXM;
    logic   na2;
    logic   RXRTR;
    logic   BUKT;
    logic   BUKT1;
    logic   FILHIT0;
} RXB0CTRL_t;


//---------------------------------------------------
// Receive buffer 1 control register
typedef struct packed {
    logic   na1;
    logic   [1:0] RXM;
    logic   na2;
    logic   RXRTR;
    logic   [2:0] FILHIT;
} RXB1CTRL_t;


//---------------------------------------------------
// Transmit buffer  (total 13x8 bits)
typedef struct packed {
    logic [10:0] STD_ID;
    logic na0;
    logic EXIDE;
    logic na1;
    logic [17:0] EXT_ID;
    logic na2;
    logic RTR;
    logic [1:0] na3;
    logic [3:0] DLC;
    logic [(8*8-1):0] DATA_BYTE;
} can_tx_buf_t;


//---------------------------------------------------
// Receive buffer  (total 13x8 bits)
typedef struct packed {
    logic [10:0] STD_ID;
    logic SRR;
    logic IDE;
    logic na1;
    logic [17:0] EXT_ID;
    logic na2;
    logic RTR;
    logic [1:0] RB;
    logic [3:0] DLC;
    logic [(8*8-1):0] DATA_BYTE;
} can_rx_buf_t;



