//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  S1FRM0001_top (
    input   wire    CLK,

    output  wire    IOA00,
    input   wire    IOA01,
    output  wire    IOA02,
    output  wire    IOA03,
    input   wire    IOA04,
    input   wire    IOA05,
    input   wire    IOA06,
    input   wire    IOA07,
    input   wire    IOA08,
    input   wire    IOA09,
    input   wire    IOA10,
    input   wire    IOA11,

    //output  wire    IOA12,
    //output  wire    IOA13,
    //output  wire    IOA14,
    //output  wire    IOA15,
    //output  wire    IOA16,
    //input   wire    IOA17,
    //output  wire    IOA18,
    //output  wire    IOA19,
    //input   wire    IOA20,
    //input   wire    IOA21,
    //output  wire    IOA22,
    //output  wire    IOA23,
    //input   wire    IOA24,
    //input   wire    IOA25,
    //output  wire    IOA26,
    //output  wire    IOA27,
    //input   wire    IOA28,
    //input   wire    IOA29,
    //output  wire    IOA30,
    //output  wire    IOA31,
    //output  wire    IOA32,
    //output  wire    IOA33,
    //output  wire    IOA34,
    //output  wire    IOA35,
    input   wire    IOA36,
    output  wire    IOA37,
    output  wire    IOA38,
    //input   wire    IOA39,
    input   wire    IOA40,
    output  wire    IOA41,

    input   wire    IOB00,
    input   wire    IOB01,
    input   wire    IOB02,
    input   wire    IOB03,
    input   wire    IOB04,
    input   wire    IOB05,
    input   wire    IOB06,
    input   wire    IOB07,
    input   wire    IOB08,
    input   wire    IOB09,
    input   wire    IOB10,
    input   wire    IOB11,
    input   wire    IOB12,
    input   wire    IOB13,
    input   wire    IOB14,
    input   wire    IOB15,

    input   wire    IOB31,
    input   wire    IOB32,
    input   wire    IOB33,
    input   wire    IOB34,
    input   wire    IOB35,
    input   wire    IOB36,
    input   wire    IOB37,
    input   wire    IOB38,
    input   wire    IOB39,
    input   wire    IOB40,
    input   wire    IOB41,
    input   wire    IOB42,
    input   wire    IOB43,
    input   wire    IOB44,

    input   wire    IOA42,
    input   wire    IOA43,

    output  wire    LED2n
);


//-----------------------------------------------------------
wire    CAN_CSn;
wire    CAN_INTn;
wire    CAN_SCK;
wire    CAN_SI;
wire    CAN_SO;

wire    FRAM_CSn;
wire    FRAM_SCK;
wire    FRAM_SI;
wire    FRAM_SO;

//wire    [7:0]  LVDS_D;
//wire    [7:0]  LVDS_DEn;
//wire    [7:0]  LVDS_R;
//wire    LVDS_REn;

wire    [3:0]  SW1;
wire    [3:0]  SW2;

wire    [31:0] DI;



//-----------------------------------------------------------

s1frm0001_core      the_s1frm0001_core (
    .CLK       (CLK),

    .CAN_CSn   (CAN_CSn),
    .CAN_INTn  (CAN_INTn),
    .CAN_SCK   (CAN_SCK),
    .CAN_SI    (CAN_SI),
    .CAN_SO    (CAN_SO),

    .FRAM_CSn  (FRAM_CSn),
    .FRAM_SCK  (FRAM_SCK),
    .FRAM_SI   (FRAM_SI),
    .FRAM_SO   (FRAM_SO),

    .LED2n     (LED2n),

    //.LVDS_REn  (LVDS_REn),
    //.LVDS_D    (LVDS_D),
    //.LVDS_DEn  (LVDS_DEn),
    //.LVDS_R    (LVDS_R),

    .SW1       (SW1),
    .SW2       (SW2),

    .DI        (DI)
);


assign  IOA41    = CAN_CSn;
assign  CAN_INTn = IOA36;
assign  IOA37    = CAN_SCK;
assign  IOA38    = CAN_SI;
assign  CAN_SO   = IOA40;

assign  IOA00   = FRAM_CSn;
assign  IOA02   = FRAM_SCK;
assign  IOA03   = FRAM_SI;
assign  FRAM_SO = IOA01;


//assign  IOA31 = LVDS_D[7];
//assign  IOA30 = LVDS_D[6];
//assign  IOA27 = LVDS_D[5];
//assign  IOA26 = LVDS_D[4];
//assign  IOA23 = LVDS_D[3];
//assign  IOA22 = LVDS_D[2];
//assign  IOA19 = LVDS_D[1];
//assign  IOA18 = LVDS_D[0];
//
//assign  IOA35 = LVDS_DEn[7];
//assign  IOA34 = LVDS_DEn[6];
//assign  IOA33 = LVDS_DEn[5];
//assign  IOA32 = LVDS_DEn[4];
//assign  IOA15 = LVDS_DEn[3];
//assign  IOA14 = LVDS_DEn[2];
//assign  IOA13 = LVDS_DEn[1];
//assign  IOA12 = LVDS_DEn[0];
//
//assign  LVDS_R[7] = IOA39;
//assign  LVDS_R[6] = IOA29;
//assign  LVDS_R[5] = IOA28;
//assign  LVDS_R[4] = IOA25;
//assign  LVDS_R[3] = IOA24;
//assign  LVDS_R[2] = IOA21;
//assign  LVDS_R[1] = IOA20;
//assign  LVDS_R[0] = IOA17;
//
//assign  IOA16 = LVDS_REn;


assign  SW1[3] = IOA07;
assign  SW1[2] = IOA05;
assign  SW1[1] = IOA04;
assign  SW1[0] = IOA06;

assign  SW2[3] = IOA11;
assign  SW2[2] = IOA08;
assign  SW2[1] = IOA09;
assign  SW2[0] = IOA10;




assign  DI[31] = IOB00;
assign  DI[30] = IOB01;
assign  DI[29] = IOB02;
assign  DI[28] = IOB03;
assign  DI[27] = IOB04;
assign  DI[26] = IOB05;
assign  DI[25] = IOB06;
assign  DI[24] = IOB07;
assign  DI[23] = IOB08;
assign  DI[22] = IOB09;
assign  DI[21] = IOB10;
assign  DI[20] = IOB11;
assign  DI[19] = IOB12;
assign  DI[18] = IOB13;
assign  DI[17] = IOB14;
assign  DI[16] = IOB15;


assign  DI[15] = IOB31;
assign  DI[14] = IOB32;
assign  DI[13] = IOB33;
assign  DI[12] = IOB34;
assign  DI[11] = IOB35;
assign  DI[10] = IOB36;
assign  DI[09] = IOB37;
assign  DI[08] = IOB38;
assign  DI[07] = IOB39;
assign  DI[06] = IOB40;
assign  DI[05] = IOB41;
assign  DI[04] = IOB42;
assign  DI[03] = IOB43;
assign  DI[02] = IOB44;

assign  DI[01] = IOA42;  // IOA
assign  DI[00] = IOA43;  // IOA






endmodule

