//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  S1FRM0002_top (
    input   wire    CLK,

    output  wire    IOA00,
    input   wire    IOA01,
    output  wire    IOA02,
    output  wire    IOA03,
    input   wire    IOA04,
    input   wire    IOA05,
    input   wire    IOA06,
    input   wire    IOA07,
    input   wire    IOA08,
    input   wire    IOA09,
    input   wire    IOA10,
    input   wire    IOA11,

    //output  wire    IOA12,
    //output  wire    IOA13,
    //output  wire    IOA14,
    //output  wire    IOA15,
    //output  wire    IOA16,
    //input   wire    IOA17,
    //output  wire    IOA18,
    //output  wire    IOA19,
    //input   wire    IOA20,
    //input   wire    IOA21,
    //output  wire    IOA22,
    //output  wire    IOA23,
    //input   wire    IOA24,
    //input   wire    IOA25,
    //output  wire    IOA26,
    //output  wire    IOA27,
    //input   wire    IOA28,
    //input   wire    IOA29,
    //output  wire    IOA30,
    //output  wire    IOA31,
    //output  wire    IOA32,
    //output  wire    IOA33,
    //output  wire    IOA34,
    //output  wire    IOA35,
    input   wire    IOA36,
    output  wire    IOA37,
    output  wire    IOA38,
    //input   wire    IOA39,
    input   wire    IOA40,
    output  wire    IOA41,

    output  wire    IOB00,
    output  wire    IOB01,
    output  wire    IOB02,
    output  wire    IOB03,
    output  wire    IOB04,
    output  wire    IOB05,
    output  wire    IOB06,
    output  wire    IOB07,
    output  wire    IOB08,
    output  wire    IOB09,
    output  wire    IOB10,
    output  wire    IOB11,
    output  wire    IOB12,
    output  wire    IOB13,
    output  wire    IOB14,
    output  wire    IOB15,
    output  wire    IOB31,
    output  wire    IOB32,
    output  wire    IOB33,
    output  wire    IOB34,
    output  wire    IOB35,
    output  wire    IOB36,
    output  wire    IOB37,
    output  wire    IOB38,
    output  wire    IOB39,
    output  wire    IOB40,
    output  wire    IOB41,
    output  wire    IOB42,
    output  wire    IOB43,
    output  wire    IOB44,

    output  wire    IOA42,
    output  wire    IOA43,

    output  wire    LED2n
);


//-----------------------------------------------------------
wire    CAN_CSn;
wire    CAN_INTn;
wire    CAN_SCK;
wire    CAN_SI;
wire    CAN_SO;

wire    FRAM_CSn;
wire    FRAM_SCK;
wire    FRAM_SI;
wire    FRAM_SO;

//wire    [7:0]  LVDS_D;
//wire    [7:0]  LVDS_DEn;
//wire    [7:0]  LVDS_R;
//wire    LVDS_REn;

wire    [3:0]  SW1;
wire    [3:0]  SW2;

wire    [31:0] DOn;



//-----------------------------------------------------------

s1frm0002_core      the_s1frm0002_core (
    .CLK       (CLK),

    .CAN_CSn   (CAN_CSn),
    .CAN_INTn  (CAN_INTn),
    .CAN_SCK   (CAN_SCK),
    .CAN_SI    (CAN_SI),
    .CAN_SO    (CAN_SO),

    .FRAM_CSn  (FRAM_CSn),
    .FRAM_SCK  (FRAM_SCK),
    .FRAM_SI   (FRAM_SI),
    .FRAM_SO   (FRAM_SO),

    .LED2n     (LED2n),

    //.LVDS_REn  (LVDS_REn),
    //.LVDS_D    (LVDS_D),
    //.LVDS_DEn  (LVDS_DEn),
    //.LVDS_R    (LVDS_R),

    .SW1       (SW1),
    .SW2       (SW2),

    .DOn       (DOn)
);


assign  IOA41    = CAN_CSn;
assign  CAN_INTn = IOA36;
assign  IOA37    = CAN_SCK;
assign  IOA38    = CAN_SI;
assign  CAN_SO   = IOA40;

assign  IOA00   = FRAM_CSn;
assign  IOA02   = FRAM_SCK;
assign  IOA03   = FRAM_SI;
assign  FRAM_SO = IOA01;


//assign  IOA31 = LVDS_D[7];
//assign  IOA30 = LVDS_D[6];
//assign  IOA27 = LVDS_D[5];
//assign  IOA26 = LVDS_D[4];
//assign  IOA23 = LVDS_D[3];
//assign  IOA22 = LVDS_D[2];
//assign  IOA19 = LVDS_D[1];
//assign  IOA18 = LVDS_D[0];
//
//assign  IOA35 = LVDS_DEn[7];
//assign  IOA34 = LVDS_DEn[6];
//assign  IOA33 = LVDS_DEn[5];
//assign  IOA32 = LVDS_DEn[4];
//assign  IOA15 = LVDS_DEn[3];
//assign  IOA14 = LVDS_DEn[2];
//assign  IOA13 = LVDS_DEn[1];
//assign  IOA12 = LVDS_DEn[0];
//
//assign  LVDS_R[7] = IOA39;
//assign  LVDS_R[6] = IOA29;
//assign  LVDS_R[5] = IOA28;
//assign  LVDS_R[4] = IOA25;
//assign  LVDS_R[3] = IOA24;
//assign  LVDS_R[2] = IOA21;
//assign  LVDS_R[1] = IOA20;
//assign  LVDS_R[0] = IOA17;
//
//assign  IOA16 = LVDS_REn;


assign  SW1[3] = IOA07;
assign  SW1[2] = IOA05;
assign  SW1[1] = IOA04;
assign  SW1[0] = IOA06;

assign  SW2[3] = IOA11;
assign  SW2[2] = IOA08;
assign  SW2[1] = IOA09;
assign  SW2[0] = IOA10;




assign  IOB00 = DOn[31];
assign  IOB01 = DOn[30];
assign  IOB02 = DOn[29];
assign  IOB03 = DOn[28];
assign  IOB04 = DOn[27];
assign  IOB05 = DOn[26];
assign  IOB06 = DOn[25];
assign  IOB07 = DOn[24];
assign  IOB08 = DOn[23];
assign  IOB09 = DOn[22];
assign  IOB10 = DOn[21];
assign  IOB11 = DOn[20];
assign  IOB12 = DOn[19];
assign  IOB13 = DOn[18];
assign  IOB14 = DOn[17];
assign  IOB15 = DOn[16];
             
             
assign  IOB31 = DOn[15];
assign  IOB32 = DOn[14];
assign  IOB33 = DOn[13];
assign  IOB34 = DOn[12];
assign  IOB35 = DOn[11];
assign  IOB36 = DOn[10];
assign  IOB37 = DOn[09];
assign  IOB38 = DOn[08];
assign  IOB39 = DOn[07];
assign  IOB40 = DOn[06];
assign  IOB41 = DOn[05];
assign  IOB42 = DOn[04];
assign  IOB43 = DOn[03];
assign  IOB44 = DOn[02];
             
assign  IOA42 = DOn[01];  // IOA
assign  IOA43 = DOn[00];  // IOA






endmodule

