//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------

task dspl_value(
        input   string name,
        input   [(128*8-1):0] value,
        input   string format = "time"
    );

    real    real_exp;

    if (format == "time") begin
        $display("    %s = %t", name, value); 
    end
    else if (format == "int") begin
        /* 桁数に 1 を指定すると、最小の桁で表示する。(以下同様) */
        $display("    %s = %1d", name, value); 
    end
    else if (format == "hex") begin
        $display("    %s = 0x%1h", name, value); 
    end
    else if (format == "bin") begin
        $display("    %s = %1b", name, value); 
    end
    else if (format == "real") begin
        real_exp = $bitstoreal( value );
        $display("    %s = %1f", name, real_exp); 
    end
    else begin
        $display("    unknown format. : %s", format); 
    end

endtask


