//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------

// CLK:16MHz システムの場合に適用する。

`ifdef BIT_RATE_1M
    localparam CNF1_SJW = 2'b0; // 1xTq
    localparam CNF1_BRP = 6'd0; // Tq = 2/Fosc
`elsif BIT_RATE_500K 
    localparam CNF1_SJW = 2'b0; // 1xTq
    localparam CNF1_BRP = 6'd1; // Tq = 4/Fosc
`else
    // 未定義の場合は、エラーにする。
`endif


localparam LP_CNF1 = {CNF1_SJW, CNF1_BRP};



localparam CNF2_BTLMODE = 1'b1;
localparam CNF2_SAM     = 1'b0;
localparam CNF2_PHSEG1  = 3'd1; // 2xTq
localparam CNF2_PHSEG   = 3'd1; // 2xTq

localparam LP_CNF2 = {CNF2_BTLMODE, CNF2_SAM, CNF2_PHSEG1, CNF2_PHSEG};



localparam CNF3_SOF    = 1'b0;
localparam CNF3_WAKFIL = 1'b0;
localparam CNF3_NA     = 2'b0;
localparam CNF3_PHSEG2 = 3'd2; // 3xTq

localparam LP_CNF3 = {CNF3_SOF, CNF3_WAKFIL, CNF3_NA, CNF3_PHSEG2};


