//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  sim_spi_cont #(
    parameter HALF_OF_SCK_PRI = 0
) (
    input   wire    reset_n,
    input   wire    ck,
    input   wire    carry,
    spi_cont_if.in  cont_in,
    spi_if.master   spi_port
);

//-----------------------------------------------------------
spi_cont_if     cont_in_relay();


//-----------------------------------------------------------

spi_cont #(
    .HALF_OF_SCK_PRI    (HALF_OF_SCK_PRI)
)
a_spi_cont ( 
    .ck         (ck),
    .reset_n    (reset_n),
    .cont_in    (cont_in_relay),
    .spi_port   (spi_port)
);

localparam  DELAY = 7'd100;

on_timer #(
    .CNT_BIT_WIDTH   ($bits(DELAY))
) 
request_delay (
    .*,
    .delay  (DELAY),
    .in     (cont_in.request),
    .out    (cont_in_relay.request)
);



assign  cont_in.permit      = cont_in_relay.permit;
assign  cont_in.done        = cont_in_relay.done;
assign  cont_in.shift_carry = cont_in_relay.shift_carry;
assign  cont_in.miso        = cont_in_relay.miso; 

assign  cont_in_relay.byte_num = cont_in.byte_num; 
assign  cont_in_relay.start    = cont_in.start; 
assign  cont_in_relay.mosi     = cont_in.mosi; 



endmodule

