//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

// 一連の通信が終了すると 受信したコマンドが rcv_command に格納されている。

module sim_spi_slave #(
    parameter   SREG_BYTE_LEN = 0
) (
    spi_if.slave    spi_port
);

`include "sim_timeunit.svh"
`include "shift_register_c.sv"

localparam  BIT_LEN = SREG_BYTE_LEN * 8;

//-----------------------------------------------------------
shift_register_c    #(SREG_BYTE_LEN)   sreg;

logic   [(BIT_LEN-1):0] rcv_command;
logic   [(BIT_LEN-1):0] response;

int     cmd_bit_len;
int     res_bit_len;

logic   cs, sck, mosi, miso;
logic   msb;
logic   dumy;


initial begin
    sreg = new();
    rcv_command = '0; response = '0;
    miso = 1'b1;
    cmd_bit_len = 0; res_bit_len = 0;
    msb = 1'b0;
    dumy = 1'b0;

    #1;

    forever begin
        miso = 1'b1;

        @(posedge cs)
        rcv_command = '0;
        sreg.set_byte_len( (cmd_bit_len+res_bit_len)/8 );
        sreg.data_load( response );
        miso = sreg.get_msb();

        while ( cs )  begin
            @(posedge sck) dumy = sreg.shift( mosi );
            @(negedge sck) miso = sreg.get_msb();
        end

        rcv_command = sreg.get_data() >> res_bit_len;
    end
end


assign  cs   = spi_port.cs;
assign  sck  = spi_port.sck;
assign  mosi = spi_port.mosi;

assign  spi_port.miso = miso; 



endmodule


