//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

//
//  CLK 40MHz 時、20MHz の carry を実現できるか確認する。
//
//  (1) enable してから最初の carrry の立ち下がりまでの時間
//    を計測する。
//  (2) carry 信号の１周期の時間を計測する。
//
module   test001_02_carry_gen_tb;

`include "sim_timeunit.svh"
`include "sim_settings.vh"

`include "clock.svh"

localparam  title = "\"test001_02_carry_gen_tb\"";

//-----------------------------------------------------------
logic   ck;
logic   reset_n;
time    timeout;

time    actual;
time    expected;

logic   carry_gen_en;
logic   carry_out;

// テスト用の class, task, function は、ここで展開する。 
`include "assertion_c.sv"
`include "timer_c.sv"
`include "test_timeout_tsk.sv"

//-----------------------------------------------------------
sim_clock_gen #(
    .SIM_CLK_COUNT  (SIM_CLK_COUNT)
)     
a_sim_clock_gen( .ck );


// タイムアウトで無条件に中止する。
time test_timeout_cnt;
initial begin
    test_timeout_cnt = 100 * SIM_COUNT_1MS;
    test_timeout(test_timeout_cnt);
end


//-----------------------------------------------------------
//  テスト対象のインスタンス
localparam INTERVAL = 1000;  /* pri = ck * 1000 */

carry_gen #(
    .INTERVAL   (INTERVAL)
) 
the_carry_gen (
    .ck         (ck),
    .reset_n    (reset_n),
    .en         (carry_gen_en),
    .carry      (carry_out)
);


//-----------------------------------------------------------
assertion_c test;
timer_c     tim1;

initial begin
    test = new();
    tim1 = new();

    $timeformat(-6, 3, " us", 12);

    test.title = title;

    reset_n = 1'b0;
    carry_gen_en = 1'b0;

    #100  reset_n = 1'b1;
    #500;


    //-----------------------------------------------------------------
    // (1) enable してから最初の carrry の立ち下がりまでの時間を計測する。
    test.subtitle = "(1) time : enable to carry_out ";
    expected = INTERVAL * SIM_CLK_COUNT;
    timeout  = expected + (SIM_CLK_COUNT*2);

    @(posedge ck);
    tim1.start();
    #1 carry_gen_en = 1'b1;


    test.assert_neg_edge(carry_out, timeout);

    actual = tim1.lap_time();
    test.assert_equals(expected, actual, "time");


    //-----------------------------------------------------------------
    // (2) carry_out の１周期の時間を計測する。
    test.subtitle = "(2) PRI : carry_out PRI ";
    expected = INTERVAL * SIM_CLK_COUNT;
    timeout  = expected + (SIM_CLK_COUNT*2);

    test.assert_neg_edge(carry_out, timeout);
    actual = tim1.lap_time();
    test.assert_equals(expected, actual, "time");




    $display("\n");
    $display("%s passed.", title);
    $display("\n");

    $finish(0);

end



endmodule

