//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

//
// (1) リセット信号が出力されるまでの時間を計測する。 
//
module   test101_01_reset_gen_tb;

`include "sim_timeunit.svh"
`include "sim_settings.vh"

`include "clock.svh"

localparam  title = "\"test101_01_reset_gen_tb\"";

//-----------------------------------------------------------
logic   ck;
logic   reset_n;
time    timeout;

time actual;
time expected;


// テスト用の class, task, function は、ここで展開する。 
`include "assertion_c.sv"
`include "timer_c.sv"
`include "test_timeout_tsk.sv"

//-----------------------------------------------------------
//  テスト環境用のインスタンス
localparam CARRY_INTERVAL = 40000;  // pri = ck * 4000 (1ms 相当)

sim_clock_gen #(
    .SIM_CLK_COUNT  (SIM_CLK_COUNT)
)     
a_sim_clock_gen( .ck );


// タイムアウトで無条件に中止する。
time test_timeout_cnt;
initial begin
    test_timeout_cnt = 100 * SIM_COUNT_1MS;
    test_timeout(test_timeout_cnt);
end


//-----------------------------------------------------------
//  テスト対象のインスタンス
localparam RESET_TIME_US = 100;
localparam RESET_COUNT = RESET_TIME_US * CK_COUNT_1US;

reset_gen #(
    .RESET_COUNT    (RESET_COUNT)
) 
the_reset_gen (
    .ck         (ck),
    .reset_n    (reset_n)
);



//-----------------------------------------------------------
assertion_c test;
timer_c     tim1;

initial begin
    test = new();
    tim1 = new();

    $timeformat(-6, 3, " us", 12);

    test.title = title;
    actual = 0; expected = 0;
    timeout = 0;

    //-------------------------------------------------------------
    // (1) リセット信号が出力されるまでの時間を計測する。 
    expected = (RESET_TIME_US * SIM_COUNT_1US) + SIM_CLK_COUNT;

    test.subtitle = "(1.1) wait for pos edge reset_n.";
    timeout  = expected + SIM_COUNT_1US;
    test.assert_pos_edge(reset_n, timeout);


    test.subtitle = "(1.2) reset_n rise time test.";
    actual = tim1.lap_time();
    test.assert_equals(expected, actual, "time");



    $display("\n");
    $display("%s passed.", title);
    $display("\n");

    $finish(0);

end



endmodule

