//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

//
// コンパイルが可能であることを確認する。
//
module   test501_02_s1frm0001_top_tb;

`include "sim_timeunit.svh"
`include "sim_settings.vh"

`include "clock.svh"

localparam  title = "\"test501_02_s1frm0001_top_tb\"";

//-----------------------------------------------------------
// テスト用の class, task, function は、ここで展開する。 
`include "assertion_c.sv"
`include "timer_c.sv"
`include "test_timeout_tsk.sv"


//-----------------------------------------------------------
// テスト用のパラメータ設定


//-----------------------------------------------------------
wire    ck;
logic   reset_n;

wire    IOA00;
logic   IOA01;
wire    IOA02;
wire    IOA03;
logic   IOA04;
logic   IOA05;
logic   IOA06;
logic   IOA07;
logic   IOA08;
logic   IOA09;
logic   IOA10;
logic   IOA11;
wire    IOA12;
wire    IOA13;
wire    IOA14;
wire    IOA15;
wire    IOA16;
logic   IOA17;
wire    IOA18;
logic   IOA19;
wire    IOA20;
logic   IOA21;
wire    IOA22;
logic   IOA23;
wire    IOA24;
logic   IOA25;
wire    IOA26;
logic   IOA27;
wire    IOA28;
logic   IOA29;
wire    IOA30;
wire    IOA31;
wire    IOA32;
wire    IOA33;
wire    IOA34;
wire    IOA35;
logic   IOA36;
wire    IOA37;
wire    IOA38;
logic   IOA39;
logic   IOA40;
wire    IOA41;

logic   IOB00;
logic   IOB01;
logic   IOB02;
logic   IOB03;
logic   IOB04;
logic   IOB05;
logic   IOB06;
logic   IOB07;
logic   IOB08;
logic   IOB09;
logic   IOB10;
logic   IOB11;
logic   IOB12;
logic   IOB13;
logic   IOB14;
logic   IOB15;
logic   IOB31;
logic   IOB32;
logic   IOB33;
logic   IOB34;
logic   IOB35;
logic   IOB36;
logic   IOB37;
logic   IOB38;
logic   IOB39;
logic   IOB40;
logic   IOB41;
logic   IOB42;
logic   IOB43;
logic   IOB44;

logic   IOA42;
logic   IOA43;

wire    LED2n;



//-----------------------------------------------------------
//  テスト環境用のインスタンス
sim_clock_gen #(
    .SIM_CLK_COUNT  (SIM_CLK_COUNT)
)     
a_sim_clock_gen( .ck );


// タイムアウトで無条件に中止する。
time test_timeout_cnt;
initial begin
    test_timeout_cnt = 100 * SIM_COUNT_1MS;
    test_timeout(test_timeout_cnt);
end


//-----------------------------------------------------------
//  テスト対象のインスタンス 

S1FRM0001_top      the_S1FRM0001_top (
    .CLK       (ck),

    .IOA00      (IOA00),
    .IOA01      (IOA01),
    .IOA02      (IOA02),
    .IOA03      (IOA03),
    .IOA04      (IOA04),
    .IOA05      (IOA05),
    .IOA06      (IOA06),
    .IOA07      (IOA07),
    .IOA08      (IOA08),
    .IOA09      (IOA09),
    .IOA10      (IOA10),
    .IOA11      (IOA11),
    //.IOA12      (IOA12),
    //.IOA13      (IOA13),
    //.IOA14      (IOA14),
    //.IOA15      (IOA15),
    //.IOA16      (IOA16),
    //.IOA17      (IOA17),
    //.IOA18      (IOA18),
    //.IOA19      (IOA19),
    //.IOA20      (IOA20),
    //.IOA21      (IOA21),
    //.IOA22      (IOA22),
    //.IOA23      (IOA23),
    //.IOA24      (IOA24),
    //.IOA25      (IOA25),
    //.IOA26      (IOA26),
    //.IOA27      (IOA27),
    //.IOA28      (IOA28),
    //.IOA29      (IOA29),
    //.IOA30      (IOA30),
    //.IOA31      (IOA31),
    //.IOA32      (IOA32),
    //.IOA33      (IOA33),
    //.IOA34      (IOA34),
    //.IOA35      (IOA35),
    .IOA36      (IOA36),
    .IOA37      (IOA37),
    .IOA38      (IOA38),
    //.IOA39      (IOA39),
    .IOA40      (IOA40),
    .IOA41      (IOA41),

    .IOB00      (IOB00),
    .IOB01      (IOB01),
    .IOB02      (IOB02),
    .IOB03      (IOB03),
    .IOB04      (IOB04),
    .IOB05      (IOB05),
    .IOB06      (IOB06),
    .IOB07      (IOB07),
    .IOB08      (IOB08),
    .IOB09      (IOB09),
    .IOB10      (IOB10),
    .IOB11      (IOB11),
    .IOB12      (IOB12),
    .IOB13      (IOB13),
    .IOB14      (IOB14),
    .IOB15      (IOB15),
    .IOB31      (IOB31),
    .IOB32      (IOB32),
    .IOB33      (IOB33),
    .IOB34      (IOB34),
    .IOB35      (IOB35),
    .IOB36      (IOB36),
    .IOB37      (IOB37),
    .IOB38      (IOB38),
    .IOB39      (IOB39),
    .IOB40      (IOB40),
    .IOB41      (IOB41),
    .IOB42      (IOB42),
    .IOB43      (IOB43),
    .IOB44      (IOB44),

    .IOA42      (IOA42),
    .IOA43      (IOA43),

    .LED2n      (LED2n)
);



//-----------------------------------------------------------
assertion_c test;
timer_c     tim1;


initial begin
    test = new();
    tim1 = new();

    $timeformat(-6, 3, " us", 12);
    test.title = title;

    reset_n = 1'b0;

    IOA01 = 1'b0;
    IOA04 = 1'b0;
    IOA05 = 1'b0;
    IOA06 = 1'b0;
    IOA07 = 1'b0;
    IOA08 = 1'b0;
    IOA09 = 1'b0;
    IOA10 = 1'b0;
    IOA11 = 1'b0;
    IOA17 = 1'b0;
    IOA19 = 1'b0;
    IOA21 = 1'b0;
    IOA23 = 1'b0;
    IOA25 = 1'b0;
    IOA27 = 1'b0;
    IOA29 = 1'b0;
    IOA36 = 1'b0;
    IOA39 = 1'b0;
    IOA40 = 1'b0;
    IOA42 = 1'b0;
    IOA43 = 1'b0;
    IOB00 = 1'b0;
    IOB01 = 1'b0;
    IOB02 = 1'b0;
    IOB03 = 1'b0;
    IOB04 = 1'b0;
    IOB05 = 1'b0;
    IOB06 = 1'b0;
    IOB07 = 1'b0;
    IOB08 = 1'b0;
    IOB09 = 1'b0;
    IOB10 = 1'b0;
    IOB11 = 1'b0;
    IOB12 = 1'b0;
    IOB13 = 1'b0;
    IOB14 = 1'b0;
    IOB15 = 1'b0;
    IOB31 = 1'b0;
    IOB32 = 1'b0;
    IOB33 = 1'b0;
    IOB34 = 1'b0;
    IOB35 = 1'b0;
    IOB36 = 1'b0;
    IOB37 = 1'b0;
    IOB38 = 1'b0;
    IOB39 = 1'b0;
    IOB40 = 1'b0;
    IOB41 = 1'b0;
    IOB42 = 1'b0;
    IOB43 = 1'b0;
    IOB44 = 1'b0;



    #100  reset_n = 1'b1;
    #500;

    @(posedge ck);


    #(SIM_COUNT_1US*100);



    $display("\n");
    $display("%s passed.", title);
    $display("\n");

    $finish(0);


end



endmodule

