//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

//
// コンパイルが可能であることを確認する。
//
module   test503_01_s1frm0001t_core_tb;

`include "sim_timeunit.svh"
`include "sim_settings.vh"

`include "clock.svh"

localparam  title = "\"test501_01_s1frm0001t_core_tb\"";

//-----------------------------------------------------------
// テスト用の class, task, function は、ここで展開する。 
`include "assertion_c.sv"
`include "timer_c.sv"
`include "test_timeout_tsk.sv"


//-----------------------------------------------------------
// テスト用のパラメータ設定


//-----------------------------------------------------------
logic   ck, reset_n;

logic   CAN_CSn;
logic   CAN_INTn;
logic   CAN_SCK;
logic   CAN_SI;
logic   CAN_SO;
logic   FRAM_CSn;
logic   FRAM_SCK;
logic   FRAM_SI;
logic   FRAM_SO;
logic   LED2n;
//logic   LVDS_REn;
//logic   [7:0]  LVDS_D;
//logic   [7:0]  LVDS_DEn;
//logic   [7:0]  LVDS_R;
logic   [3:0]  SW1;
logic   [3:0]  SW2;
logic   [31:0] DI;

//-----------------------------------------------------------
//  テスト環境用のインスタンス
sim_clock_gen #(
    .SIM_CLK_COUNT  (SIM_CLK_COUNT)
)     
a_sim_clock_gen( .ck );


// タイムアウトで無条件に中止する。
time test_timeout_cnt;
initial begin
    test_timeout_cnt = 100 * SIM_COUNT_1MS;
    test_timeout(test_timeout_cnt);
end


//-----------------------------------------------------------
//  テスト対象のインスタンス 

s1frm0001t_core      the_s1frm0001t_core (
    .CLK       (ck),

    .CAN_CSn   (CAN_CSn),
    .CAN_INTn  (CAN_INTn),
    .CAN_SCK   (CAN_SCK),
    .CAN_SI    (CAN_SI),
    .CAN_SO    (CAN_SO),

    .FRAM_CSn  (FRAM_CSn),
    .FRAM_SCK  (FRAM_SCK),
    .FRAM_SI   (FRAM_SI),
    .FRAM_SO   (FRAM_SO),

    .LED2n     (LED2n),

    //.LVDS_REn  (LVDS_REn),
    //.LVDS_D    (LVDS_D),
    //.LVDS_DEn  (LVDS_DEn),
    //.LVDS_R    (LVDS_R),

    .SW1       (SW1),
    .SW2       (SW2),

    .DI        (DI)
);


//-----------------------------------------------------------
assertion_c test;
timer_c     tim1;


initial begin
    test = new();
    tim1 = new();

    $timeformat(-6, 3, " us", 12);
    test.title = title;

    reset_n = 1'b0;

    CAN_INTn = 1'b1;
    CAN_SO   = 1'b0;
    FRAM_SO  = 1'b0;
    SW1      = '1;
    SW2      = '1;
    DI       = '1;


    #100  reset_n = 1'b1;
    #500;

    @(posedge ck);


    #(SIM_COUNT_1US*100);



    $display("\n");
    $display("%s passed.", title);
    $display("\n");

    $finish(0);


end



endmodule

