//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  carry_gen #(
    parameter INTERVAL = 0,
    parameter INTERVAL_1ST = INTERVAL
) (
    input   wire   reset_n,
    input   wire   ck,
    input   wire   en,
    output  logic  carry
);

localparam  INIT_COUNT = (INTERVAL - INTERVAL_1ST) + 2;
localparam  MSB = $clog2(INTERVAL);

`include "assert_param.svh"
initial begin
    `assert_param(INTERVAL >= 2, INTERVAL)
end


//-----------------------------------------------------------
logic   [MSB:0] count;


//-----------------------------------------------------------

always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n )
        count <= INIT_COUNT[MSB:0];
    else if ( ~en )
        count <= INIT_COUNT[MSB:0];
    else begin
        if (count < INTERVAL[MSB:0])
            count <= count + 1'd1;
        else
            count <= 1'd1;
    end
end


always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n )
        carry <= 1'b0;
    else if ( ~en )
        carry <= 1'b0;
    else begin
        if (count < INTERVAL[MSB:0])
            carry <= 1'b0;
        else
            carry <= 1'b1;
    end
end


endmodule

