//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  chattering_filter #(
    parameter SIG_BIT_WIDTH = 0,
    parameter CNT_BIT_WIDTH = 0
) (
    input   wire    reset_n,
    input   wire    ck,
    input   wire    carry,
    input   wire    [CNT_BIT_WIDTH-1:0] duration,
    input   wire    [SIG_BIT_WIDTH-1:0] data_in,
    output  logic   [SIG_BIT_WIDTH-1:0] data_out,
    output  logic   update
);


//------------------------------------------------------------
logic   match;
logic   accept;
logic   [SIG_BIT_WIDTH-1:0] data_in_1;
logic   [SIG_BIT_WIDTH-1:0] data_in_2;


always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n ) begin
        data_in_1 <= '0;
        data_in_2 <= '0;
    end
    else begin
        data_in_1 <= data_in;
        data_in_2 <= data_in_1;
    end
end

assign  match = (data_in_1 == data_in_2);


on_timer #(
    .CNT_BIT_WIDTH  (CNT_BIT_WIDTH)
) 
data_match_timer (
    .*,
    .delay  (duration),
    .in     (match),
    .out    (accept)
);


always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n ) begin
        data_out <= '0;
    end
    else begin 
        if ( accept )
            data_out <= data_in_2;
        else
            data_out <= data_out;
    end
end


rise_detector   update_gen (
    .* ,
   .in       (accept),
   .out      (update)
);


endmodule

