//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  rise_detector (
    input   wire    ck,
    input   wire    reset_n,
    input   wire    in,
    output  logic   out
);

//-----------------------------------------------------------
logic   last_in;


//-----------------------------------------------------------
always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n )
        last_in <= 1'b0;
    else
        last_in <= in;
end


always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n )
        out <= 1'b0;
    else if ({last_in, in} == 2'b01)
        out <= 1'b1;
    else
        out <= 1'b0;
end



endmodule

