//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  digital_input #(
    parameter SIG_BIT_WIDTH = 0,
    parameter CNT_BIT_WIDTH = 0
) (
    input   wire    reset_n,
    input   wire    ck,
    input   wire    carry,
    input   wire    [CNT_BIT_WIDTH-1:0] duration,
    input   wire    [SIG_BIT_WIDTH-1:0] data_in,
    output  logic   [SIG_BIT_WIDTH-1:0] data_out,
    output  logic   changed
);


//-----------------------------------------------------------

chattering_filter #(
    .SIG_BIT_WIDTH      (SIG_BIT_WIDTH),
    .CNT_BIT_WIDTH      (CNT_BIT_WIDTH)
) 
din_chatter_filter (
    .*,
    .duration   (duration),

    .data_in    (data_in),
    .data_out   (data_out),
    .update     (changed)
);




endmodule

