//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  parallel_out_msg #(
    parameter MSG_ID  = 8'h00,
    parameter DLC_MIN = 0,
    parameter DLC_MAX = 0,
    parameter BIT_WIDTH = 0
) (
    input   wire    reset_n,
    input   wire    ck,

    can_msg_if.in   can_msg_in,
    output  logic   [BIT_WIDTH-1:0] data,
    output  logic   trig_out
);

`include "assert_param.svh"
initial begin
    `assert_param($bits(MSG_ID)==8, $bits(MSG_ID))
    `assert_param(DLC_MIN <= 8, DLC_MIN)
    `assert_param(DLC_MAX <= 8, DLC_MAX)
    `assert_param2(DLC_MIN <= DLC_MAX, DLC_MIN, DLC_MAX)
end


//-------------------------------------------------------------
can_msg_if    valid_msg();


msg_data_recv #(
    .MSG_ID     (MSG_ID),
    .DLC_MIN    (DLC_MIN),
    .DLC_MAX    (DLC_MAX)
)  
para_out_msg_recv  (
    .*,
    .can_msg_in     (can_msg_in),
    .can_msg_out    (valid_msg)
);


assign  data = valid_msg.msg.data[63 -: BIT_WIDTH];

assign  trig_out = valid_msg.trig;


endmodule



