//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  request_msg #(
    parameter MSG_ID  = 0,
    parameter DLC_MIN = 0,
    parameter DLC_MAX = 0
) (
    input   wire    reset_n,
    input   wire    ck,

    can_msg_if.in   can_msg_in,
    output  logic   trig_out
);

`include "assert_param.svh"
initial begin
    `assert_param($bits(MSG_ID)==8, $bits(MSG_ID))
    `assert_param(DLC_MIN <= 8, DLC_MIN)
    `assert_param(DLC_MAX <= 8, DLC_MAX)
    `assert_param2(DLC_MIN <= DLC_MAX, DLC_MIN, DLC_MAX)
end

`include "can_msg.svh"

typedef enum logic [2:0] {
    s_init,
    s_trig_wait,
    s_message_check,
    s_msg_data_set,
    s_trig_output
} state_t;


//-------------------------------------------------------------
state_t curr_state, next_state;

logic   is_valid;


//-------------------------------------------------------------
assign  is_valid = (
    (can_msg_in.msg.msg_id == MSG_ID) &
    (DLC_MIN[3:0] <= can_msg_in.msg.dlc) & (can_msg_in.msg.dlc <= DLC_MAX[3:0])
);


assign  curr_state = next_state;

always_ff @(posedge ck or negedge reset_n) begin
    if ( ~reset_n ) begin
        trig_out <= 1'b0;
        next_state <= s_init;
    end
    else begin
        case ( curr_state )
            s_init: begin
                trig_out <= 1'b0;
                next_state <= s_trig_wait;
            end

            s_trig_wait: begin
                if ( can_msg_in.trig )
                    next_state <= s_message_check;
            end

            s_message_check: begin
                if ( is_valid )
                    next_state <= s_msg_data_set;
                else
                    next_state <= s_init;
            end

            // data がある message と同じタイミングになるようにする。
            s_msg_data_set: begin
                next_state <= s_trig_output;
            end

            s_trig_output: begin
                trig_out <= 1'b1;
                next_state <= s_init;
            end

            default: begin
                next_state <= s_init;
            end

        endcase
    end
end





endmodule



