//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

module  spi_cont #(
    parameter HALF_OF_SCK_PRI = 0
) (
    input   wire    reset_n,
    input   wire    ck,
    spi_cont_if.in  cont_in,
    spi_if.master   spi_port
);

`include "assert_param.svh"
initial begin
    `assert_param(HALF_OF_SCK_PRI >= 2, HALF_OF_SCK_PRI)
end


//-----------------------------------------------------------
logic   [7:0] byte_num;
logic   start;
logic   done;

logic   shift_carry;
logic   cs;
logic   sck;


//-----------------------------------------------------------
assign  byte_num = cont_in.byte_num;
assign  start    = cont_in.start;


// SCK の２倍の間隔の carry を生成する。

spi_sck_counter  # (
    .HALF_OF_SCK_PRI    (HALF_OF_SCK_PRI)
) 
spi_sck_cntr (
    .*,
    .byte_num       (byte_num),
    .start          (start),
    .shift_carry    (shift_carry),
    .cs             (cs),
    .sck            (sck),
    .done           (done)
);



assign  spi_port.sck = sck;
assign  spi_port.cs  = cs;
assign  spi_port.mosi = ( cs ) ? cont_in.mosi : 1'b1;


assign  cont_in.done = done;
assign  cont_in.shift_carry = shift_carry;
assign  cont_in.miso = spi_port.miso; 

assign  cont_in.permit = cont_in.request; // 無条件で折り返す。



endmodule

