//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

`include "spi_cont_comb.svh"

module  spi_cont_mixer (
    input   spi_cont_mo_t   cont_mo,
    output  spi_cont_so_t   cont_so,
    spi_cont_if.out         cont_out
);

//-------------------------------------------------------------

assign  cont_so.permit      = cont_out.permit;
assign  cont_so.done        = cont_out.done;
assign  cont_so.shift_carry = cont_out.shift_carry;
assign  cont_so.miso        = cont_out.miso;

assign  cont_out.request  = cont_mo.request;
assign  cont_out.byte_num = cont_mo.byte_num;
assign  cont_out.start    = cont_mo.start;
assign  cont_out.mosi     = cont_mo.mosi;




endmodule


