//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

`include "spi_cont_comb.svh"

module  spi_cont_splitter (
    spi_cont_if.in          cont_in,
    output  spi_cont_mo_t   cont_mo,
    input   spi_cont_so_t   cont_so
);

//-------------------------------------------------------------

assign  cont_in.permit      = cont_so.permit;
assign  cont_in.done        = cont_so.done;
assign  cont_in.shift_carry = cont_so.shift_carry;
assign  cont_in.miso        = cont_so.miso;

assign  cont_mo.request  = cont_in.request;
assign  cont_mo.byte_num = cont_in.byte_num;
assign  cont_mo.start    = cont_in.start;
assign  cont_mo.mosi     = cont_in.mosi;




endmodule

