//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------

//
//  ・LSB から MSB 方向にシフトしていく。
//  ・set_byte_len() で 仮想的に MSB の位置を設定することで、サイズを
//    変更したようなふるまいを持たせる。
//
class shift_register_c #(
        int BYTE_LEN = 0
    );
    localparam  MSB = (BYTE_LEN*8)-1;

    logic   [MSB:0] _data;
    logic   [MSB:0] _mask;
    int     _msb_pos;

    function new();
        this._data = {BYTE_LEN{8'b0}};
        this._mask = {BYTE_LEN{8'hff}};
        this._msb_pos = MSB;
    endfunction

    function void reset();
        this._data = 0;
    endfunction

    function void set_byte_len(input int byte_len);
        int bit_len = byte_len * 8;
        this._msb_pos = bit_len - 1;
        this._mask = (2**bit_len) - 1;
    endfunction

    function void data_load(input logic [MSB:0] data);
        this._data = data;
    endfunction

    function logic[MSB:0] get_data();
        return (this._data & this._mask);
    endfunction

    function logic shift(input logic lsb = 1'b0);
        logic msb = this._data[_msb_pos];
        this._data = {this._data[(MSB-1):0], lsb};
        return  msb;
    endfunction

    function logic get_msb();
        return this._data[_msb_pos];
    endfunction

endclass : shift_register_c

