//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------

class timer_c;
    time _start_time;
    time _last_lap;

    function new();
        this._start_time = 0;
        this._last_lap = 0;
    endfunction

    function void start();
        this._start_time = $time;
        this._last_lap = $time;
    endfunction

    function time split_time();
        return $time - this._start_time;
    endfunction

    function time lap_time();
        time ret = $time - this._last_lap;
        this._last_lap = $time;
        return ret;
    endfunction

endclass : timer_c 

