//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

// 一連の通信が終了すると 受信したレスポンスが rcv_response に格納されている。

module sim_spi_cmd #(
    parameter   SREG_BYTE_LEN = 0
) (
    input   wire    ck,
    input   wire    trig,
    output  logic   done,
    spi_cont_if.out spi_cont
);

`include "sim_timeunit.svh"
`include "shift_register_c.sv"

localparam  BIT_LEN = SREG_BYTE_LEN * 8;

//-----------------------------------------------------------
shift_register_c    #(SREG_BYTE_LEN)   sreg;

logic   [(BIT_LEN-1):0] command;
logic   [(BIT_LEN-1):0] rcv_response;
logic   [(BIT_LEN-1):0] response_mask;

int     cmd_bit_len;
int     res_bit_len;

logic   request, permit, start;
logic   shift_carry, miso, mosi;
logic   run;
logic   [7:0] byte_num;
logic   msb;


initial begin
    forever begin
        run = 1'b0;
        start = 1'b0;

        wait( trig );
        request = 1'b1;
        wait( permit );

        @(posedge ck); start = 1'b1; run = 1'b1;
        @(posedge ck); start = 1'b0;

        @(posedge done);
        run = 1'b0;
        disable input_loop;
    end
end


initial begin
    sreg = new();
    command = '0; rcv_response = '0; response_mask = '0;
    cmd_bit_len = 0; res_bit_len = 0;
    mosi = 1'b1; msb = 1'b0;

    forever begin
        mosi = 1'b1;

        wait( run );
        rcv_response = '0;
        byte_num = (cmd_bit_len + res_bit_len) / 8;
        sreg.set_byte_len( byte_num );
        sreg.data_load( (command << res_bit_len) );
        mosi = sreg.get_msb();

        while ( run ) begin : input_loop
            @(posedge shift_carry)
            sreg.shift( miso );

            @(negedge shift_carry)
            mosi = sreg.get_msb();
        end
        response_mask = (2**res_bit_len) -1;
        rcv_response = sreg.get_data() & response_mask;
    end
end


assign  spi_cont.request  = request;
assign  spi_cont.byte_num = byte_num;
assign  spi_cont.start    = start;
assign  spi_cont.mosi     = mosi;

assign  permit      = spi_cont.permit;
assign  done        = spi_cont.done;
assign  miso        = spi_cont.miso;
assign  shift_carry = spi_cont.shift_carry;




endmodule


