//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

// master 側のインターフェース信号を操作する。
module  sim_spi_cont_sig_master (
    spi_cont_if.out cont_out,
    input   wire    value_reset
);

logic    request;
logic    permit;

logic   [7:0] byte_num;
logic   start;
logic   done;
logic   shift_carry;
logic   miso;
logic   mosi;


initial begin
    request = 1'b0;
    byte_num = 8'b0;
    start = 1'b0;
    mosi = 1'b0;

    forever begin
        @(posedge value_reset) begin
            request = 1'b0;
            byte_num = 8'b0;
            start = 1'b0;
            mosi = 1'b0;
        end
    end

end


assign  permit      = cont_out.permit;
assign  done        = cont_out.done;
assign  miso        = cont_out.miso;
assign  shift_carry = cont_out.shift_carry;

assign  cont_out.request  = request;
assign  cont_out.byte_num = byte_num;
assign  cont_out.start    = start;
assign  cont_out.mosi     = mosi;


endmodule



// slave 側のインターフェース信号を操作する。
module  sim_spi_cont_sig_slave (
    spi_cont_if.in  cont_in,
    input   wire    value_reset
);

`include "sim_timeunit.svh"
`include "sim_settings.vh"

logic   [7:0] byte_num;
logic   start;
logic   permit;
logic   done;
logic   shift_carry;
logic   miso;
logic   mosi;


initial begin
    done = 1'b0;
    shift_carry = 1'b0;
    miso = 1'b0;

    forever begin
        @(posedge value_reset) begin
            done = 1'b0;
            shift_carry = 1'b0;
            miso = 1'b0;
        end
    end
end

initial begin
    permit = 1'b0;

    forever begin
        @(posedge cont_in.request);
        #(SIM_COUNT_1US * 100);
        cont_in.permit = cont_in.request;
        @(negedge cont_in.request);
        cont_in.permit = cont_in.request;
    end
end


// 折り返す。
//assign  cont_in.permit  = cont_in.request;

assign  byte_num = cont_in.byte_num;
assign  start    = cont_in.start;
assign  mosi     = cont_in.mosi;

assign  cont_in.done        = done;
assign  cont_in.miso        = miso;
assign  cont_in.shift_carry = shift_carry;



endmodule

