//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

//
// (1) data_load 機能を確認する。
//
module   test007_01_shift_reg_tb;

`include "sim_timeunit.svh"
`include "sim_settings.vh"

`include "clock.svh"

localparam  title = "\"test007_01_shift_reg_tb\"";
localparam  BYTE_LEN = 2;

//-----------------------------------------------------------
logic   ck;
logic   reset_n;

logic   data_load;
logic   [(BYTE_LEN*8-1):0] data_in;
logic   [(BYTE_LEN*8-1):0] data_out;
logic   shift_carry;
logic   shift_in;
logic   shift_out;

logic   [(BYTE_LEN*8-1):0] actual;
logic   [(BYTE_LEN*8-1):0] expected;

// テスト用の class, task, function は、ここで展開する。 
`include "assertion_c.sv"
`include "timer_c.sv"
`include "test_timeout_tsk.sv"

//-----------------------------------------------------------
//  テスト環境用のインスタンス
sim_clock_gen #(
    .SIM_CLK_COUNT  (SIM_CLK_COUNT)
)     
a_sim_clock_gen( .ck );


// タイムアウトで無条件に中止する。
time test_timeout_cnt;
initial begin
    test_timeout_cnt = 100 * SIM_COUNT_1MS;
    test_timeout(test_timeout_cnt);
end


//-----------------------------------------------------------
//  テスト対象のインスタンス

shift_reg #(
    .BYTE_LEN   (BYTE_LEN)
) 
the_shift_reg (
    .ck             (ck),
    .reset_n        (reset_n),
    .data_load      (data_load),
    .data_in        (data_in),
    .data_out       (data_out),
    .shift_carry    (shift_carry),
    .shift_in       (shift_in),
    .shift_out      (shift_out)
);


//-----------------------------------------------------------
assertion_c test;

initial begin
    test = new();

    test.title = title;
    reset_n = 1'b0;

    data_load   = 1'b0;
    shift_carry = 1'b0;
    shift_in    = 1'b0;
    data_in     = 16'hABCD;
    expected = data_in; 
    actual = '0;

    #100 reset_n = 1'b1;
    #1000;


    //-------------------------------------------------------------
    // (1) data load 機能の確認を行う。
    test.subtitle = "(1) data load test.";

    #(SIM_CLK_COUNT) data_load = 1'b1;
    #(SIM_CLK_COUNT) data_load = 1'b0;

    #1000 actual = data_out;

    test.assert_equals(expected, actual, "hex");



    $display("\n");
    $display("%s passed.", title);
    $display("\n");

    $finish(0);

end



endmodule

