//----------------------------------------------------------------------------
//   Copyright 2019  Simple Logic Systems Ltd.
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
//
//----------------------------------------------------------------------------
`default_nettype none

//
// 起動シーケンスを確認する。
// (1) config data を read する trig が発生する。
// (2) FRAM から data を read する。
// (3) MCP2515 の設定が行われる。
// (4) MCP2515 の割り込み待ちに入る。 
//
module   test501_03_s1frm0001_boot_sequence_tb;

`include "sim_timeunit.svh"
`include "sim_settings.vh"

`include "clock.svh"

localparam  title = "\"test501_03_s1frm0001_boot_sequence_tb\"";

//-----------------------------------------------------------
// テスト用の class, task, function は、ここで展開する。 
`include "assertion_c.sv"
`include "timer_c.sv"
`include "test_timeout_tsk.sv"


//-----------------------------------------------------------
// テスト用のパラメータ設定


//-----------------------------------------------------------
logic   ck, reset_n;

logic   CAN_CSn;
logic   CAN_INTn;
logic   CAN_SCK;
logic   CAN_SI;
logic   CAN_SO;
logic   FRAM_CSn;
logic   FRAM_SCK;
logic   FRAM_SI;
logic   FRAM_SO;
logic   LED2n;
//logic   LVDS_REn;
//logic   [7:0]  LVDS_D;
//logic   [7:0]  LVDS_DEn;
//logic   [7:0]  LVDS_R;
logic   [3:0]  SW1;
logic   [3:0]  SW2;
logic   [31:0] DI;

time    timeout;
logic   config_data_init_read;
int     expected, actual;

//-----------------------------------------------------------
//  テスト環境用のインスタンス
sim_clock_gen #(
    .SIM_CLK_COUNT  (SIM_CLK_COUNT)
)     
a_sim_clock_gen( .ck );


// タイムアウトで無条件に中止する。
time test_timeout_cnt;
initial begin
    test_timeout_cnt = 500 * SIM_COUNT_1MS;
    test_timeout(test_timeout_cnt);
end


//-----------------------------------------------------------
//  テスト対象のインスタンス 

s1frm0001_core      the_s1frm0001_core (
    .CLK       (ck),

    .CAN_CSn   (CAN_CSn),
    .CAN_INTn  (CAN_INTn),
    .CAN_SCK   (CAN_SCK),
    .CAN_SI    (CAN_SI),
    .CAN_SO    (CAN_SO),

    .FRAM_CSn  (FRAM_CSn),
    .FRAM_SCK  (FRAM_SCK),
    .FRAM_SI   (FRAM_SI),
    .FRAM_SO   (FRAM_SO),

    .LED2n     (LED2n),

    //.LVDS_REn  (LVDS_REn),
    //.LVDS_D    (LVDS_D),
    //.LVDS_DEn  (LVDS_DEn),
    //.LVDS_R    (LVDS_R),

    .SW1       (SW1),
    .SW2       (SW2),

    .DI        (DI)
);

assign  config_data_init_read = the_s1frm0001_core.config_data_init_read;


//-----------------------------------------------------------
assertion_c test;
timer_c     tim1;


initial begin
    test = new();
    tim1 = new();

    $timeformat(-6, 3, " us", 12);
    test.title = title;

    reset_n = 1'b0;

    CAN_INTn = 1'b1;
    CAN_SO   = 1'b0;
    FRAM_SO  = 1'b0;
    SW1      = '1;
    SW2      = '1;
    DI       = '1;


    #100  reset_n = 1'b1;
    #500;

    @(posedge ck);


    //-----------------------------------------------------------------
    // (1) config data を read する trig が発生する。
    test.subtitle = "(1) config_data_init_read wait.";
    timeout = 110 * SIM_COUNT_1MS;
    test.assert_pos_edge(config_data_init_read, timeout);


    //-----------------------------------------------------------------
    // (2) FRAM から data を read する。
    test.subtitle = "(2) fram cs wait.";
    timeout = 50 * SIM_COUNT_1MS;
    test.assert_pos_edge(FRAM_CSn, timeout);

    
    //-----------------------------------------------------------------
    // (3) MCP2515 の設定が行われる。
    test.subtitle = "(3.1) can cs wait. (RESET)";
    timeout = 50 * SIM_COUNT_1MS;
    test.assert_pos_edge(CAN_CSn, timeout);

    test.subtitle = "(3.2) can cs wait. (config 1)";
    timeout = 50 * SIM_COUNT_1MS;
    test.assert_pos_edge(CAN_CSn, timeout);

    test.subtitle = "(3.3) can cs wait. (config 2)";
    timeout = 50 * SIM_COUNT_1MS;
    test.assert_pos_edge(CAN_CSn, timeout);

    test.subtitle = "(3.4) can cs wait. (goto normal mode)";
    timeout = 50 * SIM_COUNT_1MS;
    test.assert_pos_edge(CAN_CSn, timeout);

    test.subtitle = "(3.5) can cs wait. (device status update)";
    timeout = 50 * SIM_COUNT_1MS;
    test.assert_pos_edge(CAN_CSn, timeout);

    #1000;

    //-----------------------------------------------------------------
    // (4) MCP2515 の割り込み待ちに入る。 
    test.subtitle = "(4) enter interrupt wait state.";
    expected = the_s1frm0001_core.can_spi_cont_switch.s_int_or_request_wait;
    actual   = the_s1frm0001_core.can_spi_cont_switch.curr_state;
    test.assert_equals(expected, actual, "int");

    


    #100000;







    $display("\n");
    $display("%s passed.", title);
    $display("\n");

    $finish(0);


end



endmodule

