"""
  Copyright 2019  Simple Logic Systems Ltd.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

"""
import unittest
from simgics.s1.can.application_message import CanMessageFrame


class CanMessageFrameTestCase(unittest.TestCase):


    def test_can_message_frame_equal_method(self):
        """CanMessageFrame の equal method をテストする."""

        #---  Setup  -------------------
        expected = CanMessageFrame()
        expected.arbitration_id = 1
        expected.data = bytearray((1,2,3,4,5,6,7,8))
        expected.dlc = len(expected.data)

        #---  Exercise  ----------------
        actual = CanMessageFrame()
        actual.arbitration_id = 1
        actual.data = bytearray((1,2,3,4,5,6,7,8))
        actual.dlc = len(actual.data)

        #---  Verify  ------------------
        self.assertTrue(expected == actual)


    def test_can_message_frame_not_equal_method_by_id(self):
        """CanMessageFrame の not equal method をテストする."""

        #---  Setup  -------------------
        expected = CanMessageFrame()
        expected.arbitration_id = 1
        expected.data = bytearray((1,2,3,4,5,6,7,8))
        expected.dlc = len(expected.data)

        #---  Exercise  ----------------
        actual = CanMessageFrame()
        actual.arbitration_id = 2 # <-- NG
        actual.data = bytearray((1,2,3,4,5,6,7,8))
        actual.dlc = len(actual.data)

        #---  Verify  ------------------
        self.assertTrue(expected != actual)


    def test_can_message_frame_not_equal_method_by_data(self):
        """CanMessageFrame の not equal method をテストする."""

        #---  Setup  -------------------
        expected = CanMessageFrame()
        expected.arbitration_id = 1
        expected.data = bytearray((1,2,3,4,5,6,7,8))
        expected.dlc = len(expected.data)

        #---  Exercise  ----------------
        actual = CanMessageFrame()
        actual.arbitration_id = 1
        actual.data = bytearray((1,2,3,4,5,6,7,100)) # <-- NG
        actual.dlc = len(actual.data)

        #---  Verify  ------------------
        self.assertTrue(expected != actual)


    def test_can_message_frame_not_equal_method_by_dlc(self):
        """CanMessageFrame の not equal method をテストする."""

        #---  Setup  -------------------
        expected = CanMessageFrame()
        expected.arbitration_id = 1
        expected.data = bytearray((1,2,3,4,5,6,7,8))
        expected.dlc = len(expected.data)

        #---  Exercise  ----------------
        actual = CanMessageFrame()
        actual.arbitration_id = 1
        actual.data = bytearray((1,2,3,4,5,6,7,8))
        actual.dlc = 7 # <-- NG

        #---  Verify  ------------------
        self.assertTrue(expected != actual)






