"""
  Copyright 2019  Simple Logic Systems Ltd.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

"""
import unittest
import can

from simgics.s1.can.application_message import CanMessageFrame
from simgics.s1.can.can_port import CanPort


class CanPortTestCase(unittest.TestCase):


    def test_to_can_msg_frm(self):
        """_to_can_msg_frm method をテストする."""

        #---  Setup  -------------------
        arbitration_id = 0x0508100
        dlc = 3
        data = bytearray((0xab, 0xcd, 0xef))

        expected = CanMessageFrame()
        expected.arbitration_id = arbitration_id
        expected.dlc = dlc
        expected.data = data

        can_msg = can.Message()
        can_msg.arbitration_id = arbitration_id
        can_msg.dlc = dlc
        can_msg.data = data.copy()
        can_msg.is_extended_id = True
        can_msg.is_error_frame = False
        can_msg.is_remote_frame = False
        can_msg.is_fd = False

        #---  Exercise  ----------------
        can_port = CanPort()
        actual = can_port._to_can_msg_frm(can_msg)

        #---  Verify  ------------------
        self.assertEqual(expected, actual)


    def test_to_can_message(self):
        """_to_can_message method をテストする."""

        #---  Setup  -------------------
        arbitration_id = 0x0508100
        dlc = 3
        data = bytearray((0xab, 0xcd, 0xef))

        msg_frm = CanMessageFrame()
        msg_frm.arbitration_id = arbitration_id
        msg_frm.dlc = dlc
        msg_frm.data = data

        expected = can.Message()
        expected.arbitration_id = arbitration_id
        expected.dlc = dlc
        expected.data = data.copy()
        expected.is_extended_id = True
        expected.is_error_frame = False
        expected.is_remote_frame = False
        expected.is_fd = False

        #---  Exercise  ----------------
        can_port = CanPort()
        actual = can_port._to_can_message(msg_frm)

        #---  Verify  ------------------
        self.assertTrue(expected.equals(actual, None))
