"""
  Copyright 2019  Simple Logic Systems Ltd.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

"""
import unittest
from simgics.s1.can.application_message import data_str_to_bytearray



class DataStrToBytearrayTestCase(unittest.TestCase):
    _DATA_LEN = 8

    def test_data_str_to_bytearray_when_hex_string_x8(self):
        """8byte の文字列の変換を確認する."""

        #---  Setup  -------------------
        data_str = "0x1122334455667788"
        expected = bytearray([0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88])

        #---  Exercise  ----------------
        actual = data_str_to_bytearray(data_str, self._DATA_LEN)

        #---  Verify  ------------------
        self.assertEqual(expected, actual)


    def test_data_str_to_bytearray_when_hex_string_x3(self):
        """3byte の文字列の変換を確認する."""

        #---  Setup  -------------------
        data_str = "0x112233"
        expected = bytearray([0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x22, 0x33])

        #---  Exercise  ----------------
        actual = data_str_to_bytearray(data_str, self._DATA_LEN)

        #---  Verify  ------------------
        self.assertEqual(expected, actual)


    def test_data_str_to_bytearray_when_dec_string(self):
        """10進数の文字列の変換を確認する."""

        #---  Setup  -------------------
        data_str = "1122867"    # 0x112233
        expected = bytearray([0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x22, 0x33])

        #---  Exercise  ----------------
        actual = data_str_to_bytearray(data_str, self._DATA_LEN)

        #---  Verify  ------------------
        self.assertEqual(expected, actual)


    def test_data_str_to_bytearray_when_overflow(self):
        """9byte の文字列の変換を行い例外が送出されることを確認する."""

        #---  Setup  -------------------
        data_str = "0x112233445566778899"

        #---  Exercise  ----------------

        #---  Verify  ------------------
        with self.assertRaises(OverflowError):
            data_str_to_bytearray(data_str, self._DATA_LEN)
            #ConfigWrite(0x01, 0x02, data_str, is_test=True)


