"""
  Copyright 2019  Simple Logic Systems Ltd.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

"""
import smbus
import time
import sys

i2c = smbus.SMBus(1)
lm75b_address = 0x48


def get_temp_reg_val():
    # +127.000(0x7f00) ~ -55.000(0xc900) (deg)
    block = i2c.read_i2c_block_data(lm75b_address, 0x00, 2)
    reg_val = (block[0] << 8) + block[1]
    return reg_val


def get_temperature():
    reg_val = get_temp_reg_val()
    val = reg_val >> 5
    if(val >= 0x400):
        val = val - 0x800
    temp = val * 0.125
    return temp


def main():
    try:
        while True:
            print("LM75B temp: %6.3f (deg)" % get_temperature())
            time.sleep(2)

    except KeyboardInterrupt:
        sys.exit()


if __name__ == "__main__":
    main()

